/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.merchant.settlement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.settlement.MerchantInfoSupplementUploadResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author mengqf
 * @version MerchantInfoSupplymentUploadRequest.java, v 0.1 2024-10-12 15:27 mengqf
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantInfoSupplementUploadRequest extends LeshuaBizRequest<MerchantInfoSupplementUploadResponse> {

    @NotBlank(message = "merchantId不能为空")
    @Length(max = 10, message = "merchantId超长")
    private String merchantId;

    /**
     * 业务类型，枚举如下：
     * 分账-ledger
     * 提现秒到-withdrawalAtOnce
     * 提现九点到-withdrawal9hourBatch
     */
    private String businessType;

    /**
     * 图片URL，最多可放6张图片
     */
    private Pics pics;

    /**
     * 文件URL，最多可放4份文件
     */
    private Pdfs pdfs;

    /**
     * 视频URL，最多可放3条视频
     */
    private Videos videos;

    @Override
    public Class<MerchantInfoSupplementUploadResponse> getResponseClass() {
        return MerchantInfoSupplementUploadResponse.class;
    }
}